"""
Dans cette version, la fonction qui effectue la lecture ne traite plus les
exceptions en cas de fichier inexistant ou de problème de permissions ce qui
implique les préconditions. C'est le programme principal qui effectue les
vérifications au préalable.
"""

import sys
import os
from typing import List

def read_text_file(path: str) -> List[str]:
	"""
	Lit un fichier texte et renvoi le contenu des lignes dans un tableau.

	@param path le chemin vers le fichier à lire
	@return un tableau contenant les lignes du fichiers

	Préconditions :
	- le fichier doit exister
	- l'utilisateur doit disposer des permissions pour le lire
	"""
	lines = []
	try:
		with open(path, "rt") as f:
			while line := f.readline():
				lines.append(line[:-1]) #-1 enlève le \n à la fin de la ligne
	except OSError as e:
		print("erreur : " + str(e), file=sys.stderr)
	return lines

if __name__ == "__main__":
	if len(sys.argv) != 2:
		print("erreur : argument manquant", file=sys.stderr)
		print("usage : " + sys.argv[0] + " chemin/vers/fichier_texte", file=sys.stderr)
		sys.exit(1)
	path = sys.argv[1]
	if not os.path.exists(path):
		print("erreur : le fichier n'existe pas", file=sys.stderr)
		sys.exit(2)
	if not os.access(path, os.R_OK):
		print("erreur : accès en lecture refusé", file=sys.stderr)
		sys.exit(3)

	lines = read_text_file(sys.argv[1])
	for i in range(len(lines)):
		print(str(i).rjust(2) + " : " + lines[i])
